#!/bin/bash

if [ -z "$1" ] || [ -z "$2" ]; then
  echo "Usage: $0 <device> <max_len>"
  exit 1
fi

DEVICE=$1
MAX_LEN=$2

LOG_FILE="./logs/classify_output_${MAX_LEN}.log"

nohup python classify_shortcut.py --device "$DEVICE" --MAX_LEN "$MAX_LEN" > "$LOG_FILE" 2>&1 &

echo "Script is running in the background. Output is being written to $LOG_FILE"
